/*
 * Decompiled with CFR 0.152.
 */
package pt.caf_pbs.schooldiskapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import pt.caf_pbs.schooldiskapi.exceptions.DuplicatedDataException;
import pt.caf_pbs.schooldiskapi.model.Enroll;
import pt.caf_pbs.schooldiskapi.model.Pair;
import pt.caf_pbs.schooldiskapi.model.Student;
import pt.caf_pbs.schooldiskapi.model.Subject;

@JsonIgnoreProperties(value={"all"})
public class EnrollContainer
implements Serializable {
    private List<Enroll> enrolls = new ArrayList();

    public List<Enroll> getEnrolls() {
        return this.enrolls;
    }

    public void setEnrolls(List<Enroll> enrolls) {
        this.enrolls = enrolls;
    }

    private Enroll search(int number, String subjectInitials) {
        for (Enroll enroll : this.enrolls) {
            Subject subject = enroll.getSubject();
            Student student = enroll.getStudent();
            if (!subject.isEqualTo(subjectInitials) || student.getNumber() != number) continue;
            return enroll;
        }
        return null;
    }

    public List<Enroll> getAll() {
        ArrayList<Enroll> newlist = new ArrayList<Enroll>();
        newlist.addAll(this.enrolls);
        return newlist;
    }

    public Enroll get(int number, String initials) {
        Enroll enroll = this.search(number, initials);
        return enroll;
    }

    public List<Pair<Subject, Integer>> getSubjects(int number) {
        ArrayList<Pair<Subject, Integer>> newlist = new ArrayList<Pair<Subject, Integer>>();
        for (Enroll enroll : this.enrolls) {
            Student student = enroll.getStudent();
            if (student.getNumber() != number) continue;
            Subject subject = enroll.getSubject();
            int grade = enroll.getGrade();
            newlist.add((Pair<Subject, Integer>)Pair.of((Object)subject, (Object)grade));
        }
        return newlist;
    }

    public List<Pair<Student, Integer>> getStudents(String initials) {
        ArrayList<Pair<Student, Integer>> newlist = new ArrayList<Pair<Student, Integer>>();
        for (Enroll enroll : this.enrolls) {
            Subject subject = enroll.getSubject();
            if (!subject.isEqualTo(initials)) continue;
            Student Student2 = enroll.getStudent();
            int grade = enroll.getGrade();
            newlist.add((Pair<Student, Integer>)Pair.of((Object)Student2, (Object)grade));
        }
        return newlist;
    }

    public void add(Enroll obj) {
        Subject subject = obj.getSubject();
        Student student = obj.getStudent();
        Enroll enroll = this.search(student.getNumber(), subject.getInitials());
        if (enroll != null) {
            String msg = "Enroll: " + student.getNumber() + " " + subject.getInitials();
            throw new DuplicatedDataException(msg);
        }
        this.enrolls.add(obj);
    }

    public void remove(int number, String initials) {
        Enroll enroll = this.search(number, initials);
        if (enroll != null) {
            this.enrolls.remove(enroll);
        }
    }

    public void update(int number, String initials, int grade) {
        Enroll enroll = this.search(number, initials);
        if (enroll != null) {
            enroll.setGrade(grade);
        }
    }
}

